package fr.asip.cps3.exemple.vues.ecrans.resultats;

import java.awt.Color;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de rsultats de la gnration d'une Signature
 */
public class SortieResultatSignatureFichier extends SortieResultatTriple {
	
	/**
	 * Libell de la signature
	 */
	private JLabel libelleSignature;
	
	/**
	 * Texte de la signature
	 */
	private JTextArea texteSignature;
	
	/**
	 * Ascenseur du texte de la signature
	 */
	private JScrollPane scrollSignature;
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de rsultat
	 */
	public SortieResultatSignatureFichier(FenetrePrincipale fenetre) {

		super(fenetre);

    	libelleSignature = new JLabel("Signature : ");
        texteSignature = new JTextArea();
        scrollSignature = new JScrollPane(texteSignature,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        texteSignature.setLineWrap(true);
        texteSignature.setWrapStyleWord(true);
        texteSignature.setEditable(false);
        scrollSignature.setBackground(Color.white);   
    	
	}
	
	/*
	 * (non-Javadoc)
	 * @see fr.asip.cps3.exemple.vues.ecrans.IEcran#affiche()
	 */
	public void affiche() {
    	
    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    		
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	
	    	// Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
			if(texteSignature != null)
				texteSignature.setText("");
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleOperation, EcranUtil.styleLibelleSortie, 0, 0, 1, 1);
	        g.ajoute(texteOperation, EcranUtil.styleTexteSortie, 0, 1, 1, 4);
	        // Ligne 1
	        g.ajoute(libelleRetour, EcranUtil.styleLibelleSortie, 1, 0, 1, 1);
	        g.ajoute(texteRetour, EcranUtil.styleTexteSortie, 1, 1, 1, 4);
	        // Ligne 2
	        g.ajoute(libelleOperation2, EcranUtil.styleLibelleSortie, 2, 0, 1, 1);
	        g.ajoute(texteOperation2, EcranUtil.styleTexteSortie, 2, 1, 1, 4);
	        // Ligne 3
	        g.ajoute(libelleCodeRetour2, EcranUtil.styleLibelleSortie, 3, 0, 1, 1);
	        g.ajoute(texteCodeRetour2, EcranUtil.styleTexteSortie, 3, 1, 1, 4);
	        // Ligne 4
	        g.ajoute(libelleOperation3, EcranUtil.styleLibelleSortie, 4, 0, 1, 1);
	        g.ajoute(texteOperation3, EcranUtil.styleTexteSortie, 4, 1, 1, 4);
	        // Ligne 5
	        g.ajoute(libelleCodeRetour3, EcranUtil.styleLibelleSortie, 5, 0, 1, 1);
	        g.ajoute(texteCodeRetour3, EcranUtil.styleTexteSortie, 5, 1, 1, 4);
	        // Ligne 6
	        g.ajoute(libelleSignature, EcranUtil.styleLibelleLigneEntiere, 6, 0, 1, 5);
	        // Ligne 7
	        g.ajoute(scrollSignature, EcranUtil.styleScrollInfos, 7, 0, 1, 5);
	        // Ligne 8
	        if(barreStatut != null)
	        	barreStatut.setText(this.fenetre.getBarreStatut().getText());
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 8, 0, 1, 6);
	        
    	}

    }

	/**
	 * Affecte le texte de la signature
	 * @param signature Le texte de la signature
	 */
	public void setSignature(String signature) {
		if(signature != null && texteSignature != null)
			texteSignature.setText(signature);
	}

}
